/*
 * Decompiled with CFR 0.152.
 */
package scrum.token;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import scrum.exception.SyntaxException;
import scrum.token.Token;
import scrum.token.TokenType;

public class TokensStack {
    private final List<Token> tokens;
    private int position;
    private static final List<TokenType> EMPTY_TOKENS = List.of(TokenType.LineBreak, TokenType.Comment);

    public Token next(TokenType type, TokenType ... types) {
        this.skipEmptyTokens();
        TokenType[] tokenTypes = ArrayUtils.add(types, type);
        if (this.position < this.tokens.size()) {
            Token token = this.tokens.get(this.position);
            if (Stream.of(tokenTypes).anyMatch(t -> t == token.getType())) {
                ++this.position;
                return token;
            }
        }
        throw new SyntaxException(String.format("After `%s` declaration expected any of the following lexemes `%s`", this.previous(), Arrays.toString((Object[])tokenTypes)));
    }

    public void back() {
        --this.position;
    }

    public boolean hasNext() {
        this.skipEmptyTokens();
        return this.position < this.tokens.size();
    }

    public Token next(TokenType type, String value, String ... values) {
        this.skipEmptyTokens();
        if (this.position < this.tokens.size()) {
            String[] allValues = ArrayUtils.add(values, value);
            Token token = this.tokens.get(this.position);
            if (token.getType() == type && Arrays.stream(allValues).anyMatch(t -> Objects.equals(t, token.getValue()))) {
                ++this.position;
                return token;
            }
        }
        throw new SyntaxException(String.format("After `%s` declaration expected `%s, %s` lexeme", new Object[]{this.previous(), type, value}));
    }

    public Token next() {
        this.skipEmptyTokens();
        return this.tokens.get(this.position++);
    }

    public boolean peek(TokenType type, String value, String ... values) {
        this.skipEmptyTokens();
        return this.peekSameLine(type, value, values);
    }

    public boolean peekSameLine(TokenType type, String value, String ... values) {
        if (this.position < this.tokens.size()) {
            String[] allValues = ArrayUtils.add(values, value);
            Token token = this.tokens.get(this.position);
            return type == token.getType() && Arrays.stream(allValues).anyMatch(t -> Objects.equals(t, token.getValue()));
        }
        return false;
    }

    public boolean peek(TokenType type, TokenType ... types) {
        this.skipEmptyTokens();
        return this.peekSameLine(type, types);
    }

    public boolean peekSameLine(TokenType type, TokenType ... types) {
        if (this.position < this.tokens.size()) {
            TokenType[] tokenTypes = ArrayUtils.add(types, type);
            Token token = this.tokens.get(this.position);
            return Stream.of(tokenTypes).anyMatch(t -> t == token.getType());
        }
        return false;
    }

    private Token previous() {
        return this.tokens.get(this.position - 1);
    }

    private void skipEmptyTokens() {
        while (this.position != this.tokens.size() && EMPTY_TOKENS.contains((Object)this.tokens.get(this.position).getType())) {
            ++this.position;
        }
    }

    @Generated
    public TokensStack(List<Token> tokens) {
        this.tokens = tokens;
    }
}

