/*
 * Decompiled with CFR 0.152.
 */
package scrum.statement.loop;

import java.util.Iterator;
import lombok.Generated;
import scrum.context.MemoryContext;
import scrum.exception.ExecutionException;
import scrum.expression.Expression;
import scrum.expression.VariableExpression;
import scrum.expression.value.IterableValue;
import scrum.expression.value.Value;
import scrum.statement.loop.AbstractLoopStatement;

public class IterableLoopStatement
extends AbstractLoopStatement {
    private final VariableExpression variableExpression;
    private final Expression iterableExpression;
    private Iterator<Value<?>> iterator;

    @Override
    protected void init() {
        Value<?> value = this.iterableExpression.evaluate();
        if (!(value instanceof IterableValue)) {
            throw new ExecutionException(String.format("Unable to loop non IterableValue `%s`", value));
        }
        this.iterator = ((IterableValue)value).iterator();
    }

    @Override
    protected boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    protected void preIncrement() {
        MemoryContext.getScope().set(this.variableExpression.getName(), this.iterator.next());
    }

    @Override
    protected void postIncrement() {
    }

    @Generated
    public IterableLoopStatement(VariableExpression variableExpression, Expression iterableExpression) {
        this.variableExpression = variableExpression;
        this.iterableExpression = iterableExpression;
    }
}

