/*
 * Decompiled with CFR 0.152.
 */
package scrum.statement.loop;

import lombok.Generated;
import scrum.context.MemoryContext;
import scrum.expression.Expression;
import scrum.expression.VariableExpression;
import scrum.expression.operator.AdditionOperator;
import scrum.expression.operator.LessThanOperator;
import scrum.expression.value.LogicalValue;
import scrum.expression.value.NumericValue;
import scrum.expression.value.Value;
import scrum.statement.loop.AbstractLoopStatement;

public class ForLoopStatement
extends AbstractLoopStatement {
    private final VariableExpression variable;
    private final Expression lowerBound;
    private final Expression uppedBound;
    private final Expression step;
    private static final Expression DEFAULT_STEP = new NumericValue(1.0);

    public ForLoopStatement(VariableExpression variable, Expression lowerBound, Expression uppedBound) {
        this(variable, lowerBound, uppedBound, DEFAULT_STEP);
    }

    @Override
    protected void init() {
        MemoryContext.getScope().set(this.variable.getName(), this.lowerBound.evaluate());
    }

    @Override
    protected boolean hasNext() {
        LessThanOperator hasNext = new LessThanOperator(this.variable, this.uppedBound);
        Value<?> value = hasNext.evaluate();
        return value instanceof LogicalValue && (Boolean)((LogicalValue)value).getValue() != false;
    }

    @Override
    protected void preIncrement() {
    }

    @Override
    protected void postIncrement() {
        AdditionOperator stepOperator = new AdditionOperator(this.variable, this.step);
        MemoryContext.getScope().set(this.variable.getName(), stepOperator.evaluate());
    }

    @Generated
    public ForLoopStatement(VariableExpression variable, Expression lowerBound, Expression uppedBound, Expression step) {
        this.variable = variable;
        this.lowerBound = lowerBound;
        this.uppedBound = uppedBound;
        this.step = step;
    }
}

