/*
 * Decompiled with CFR 0.152.
 */
package scrum.statement;

import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import scrum.context.MemoryContext;
import scrum.exception.ExecutionException;
import scrum.expression.Expression;
import scrum.expression.value.LogicalValue;
import scrum.expression.value.Value;
import scrum.statement.CompositeStatement;
import scrum.statement.Statement;

public class ConditionStatement
implements Statement {
    private final Map<Expression, CompositeStatement> cases = new LinkedHashMap<Expression, CompositeStatement>();

    public void addCase(Expression caseCondition, CompositeStatement caseStatement) {
        this.cases.put(caseCondition, caseStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        for (Map.Entry<Expression, CompositeStatement> entry : this.cases.entrySet()) {
            Expression condition = entry.getKey();
            Value<?> value = condition.evaluate();
            if (!(value instanceof LogicalValue)) {
                throw new ExecutionException(String.format("Cannot compare non logical value `%s`", value));
            }
            if (!((Boolean)((LogicalValue)value).getValue()).booleanValue()) continue;
            MemoryContext.pushScope(MemoryContext.newScope());
            try {
                CompositeStatement statement = entry.getValue();
                statement.execute();
                break;
            }
            finally {
                MemoryContext.endScope();
            }
        }
    }

    @Generated
    public Map<Expression, CompositeStatement> getCases() {
        return this.cases;
    }
}

