/*
 * Decompiled with CFR 0.152.
 */
package scrum.expression.value;

import java.util.Iterator;
import java.util.stream.Collectors;
import lombok.Generated;
import scrum.context.MemoryContext;
import scrum.context.MemoryScope;
import scrum.context.definition.ClassDefinition;
import scrum.expression.value.IterableValue;
import scrum.expression.value.NullValue;
import scrum.expression.value.Value;

public class ClassValue
extends IterableValue<ClassDefinition> {
    private final MemoryScope memoryScope;

    public ClassValue(ClassDefinition definition, MemoryScope memoryScope) {
        super(definition);
        this.memoryScope = memoryScope;
    }

    @Override
    public String toString() {
        MemoryContext.pushScope(this.memoryScope);
        try {
            String string = ((ClassDefinition)this.getValue()).getArguments().stream().map(t -> t + " = " + String.valueOf(this.getValue((String)t))).collect(Collectors.joining(", ", ((ClassDefinition)this.getValue()).getName() + " [ ", " ]"));
            return string;
        }
        finally {
            MemoryContext.endScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value<?> getValue(String name) {
        MemoryContext.pushScope(this.memoryScope);
        try {
            Value<?> result = MemoryContext.getScope().getLocal(name);
            Value<?> value = result != null ? result : NullValue.NULL_INSTANCE;
            return value;
        }
        finally {
            MemoryContext.endScope();
        }
    }

    public void setValue(String name, Value<?> value) {
        MemoryContext.pushScope(this.memoryScope);
        try {
            MemoryContext.getScope().setLocal(name, value);
        }
        finally {
            MemoryContext.endScope();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        ClassValue oValue = (ClassValue)o;
        return ((ClassDefinition)this.getValue()).getArguments().stream().allMatch(e -> this.getValue((String)e).equals(oValue.getValue((String)e)));
    }

    @Override
    public Iterator<Value<?>> iterator() {
        return ((ClassDefinition)this.getValue()).getArguments().stream().map(this::getValue).iterator();
    }

    @Generated
    public MemoryScope getMemoryScope() {
        return this.memoryScope;
    }
}

