/*
 * Decompiled with CFR 0.152.
 */
package scrum.expression.operator;

import java.util.Arrays;
import java.util.Objects;
import lombok.Generated;
import scrum.expression.operator.AdditionOperator;
import scrum.expression.operator.ArrayAppendOperator;
import scrum.expression.operator.AssignmentOperator;
import scrum.expression.operator.ClassInstanceOperator;
import scrum.expression.operator.ClassPropertyOperator;
import scrum.expression.operator.DivisionOperator;
import scrum.expression.operator.EqualsOperator;
import scrum.expression.operator.FloorDivisionOperator;
import scrum.expression.operator.GreaterThanOperator;
import scrum.expression.operator.GreaterThanOrEqualToOperator;
import scrum.expression.operator.LessThanOperator;
import scrum.expression.operator.LessThanOrEqualToOperator;
import scrum.expression.operator.LogicalAndOperator;
import scrum.expression.operator.LogicalOrOperator;
import scrum.expression.operator.ModuloOperator;
import scrum.expression.operator.MultiplicationOperator;
import scrum.expression.operator.NotEqualsOperator;
import scrum.expression.operator.NotOperator;
import scrum.expression.operator.OperatorExpression;
import scrum.expression.operator.SubtractionOperator;

public enum Operator {
    Not("NOT", NotOperator.class, 7),
    ClassInstance("NEW", ClassInstanceOperator.class, 7),
    ClassProperty("::", ClassPropertyOperator.class, 7),
    Multiplication("*", MultiplicationOperator.class, 6),
    Division("/", DivisionOperator.class, 6),
    FloorDivision("//", FloorDivisionOperator.class, 6),
    Modulo("%", ModuloOperator.class, 6),
    Addition("+", AdditionOperator.class, 5),
    Subtraction("-", SubtractionOperator.class, 5),
    Equals("=", EqualsOperator.class, 4),
    NotEquals("<>", NotEqualsOperator.class, 4),
    LessThan("<", LessThanOperator.class, 4),
    LessThanOrEqualTo("<=", LessThanOrEqualToOperator.class, 4),
    GreaterThan(">", GreaterThanOperator.class, 4),
    GreaterThanOrEqualTo(">=", GreaterThanOrEqualToOperator.class, 4),
    LeftParen("(", 3),
    RightParen(")", 3),
    LogicalAnd("AND", LogicalAndOperator.class, 2),
    LogicalOr("OR", LogicalOrOperator.class, 1),
    ArrayAppend("ADDING", ArrayAppendOperator.class, 0),
    Assignment("IS", AssignmentOperator.class, 0);

    private final String character;
    private final Class<? extends OperatorExpression> type;
    private final Integer precedence;

    private Operator(String character, Integer precedence) {
        this(character, null, precedence);
    }

    public static Operator getType(String character) {
        return Arrays.stream(Operator.values()).filter(t -> Objects.equals(t.getCharacter(), character)).findAny().orElse(null);
    }

    public boolean greaterThan(Operator o) {
        return this.getPrecedence().compareTo(o.getPrecedence()) >= 0;
    }

    @Generated
    private Operator(String character, Class<? extends OperatorExpression> type, Integer precedence) {
        this.character = character;
        this.type = type;
        this.precedence = precedence;
    }

    @Generated
    public String getCharacter() {
        return this.character;
    }

    @Generated
    public Class<? extends OperatorExpression> getType() {
        return this.type;
    }

    @Generated
    public Integer getPrecedence() {
        return this.precedence;
    }
}

