/*
 * Decompiled with CFR 0.152.
 */
package scrum.expression.operator;

import java.util.Objects;
import scrum.exception.ExecutionException;
import scrum.expression.Expression;
import scrum.expression.operator.BinaryOperatorExpression;
import scrum.expression.value.ComparableValue;
import scrum.expression.value.LogicalValue;
import scrum.expression.value.NullValue;
import scrum.expression.value.Value;

public class LessThanOrEqualToOperator
extends BinaryOperatorExpression {
    public LessThanOrEqualToOperator(Expression left, Expression right) {
        super(left, right);
    }

    @Override
    public Value<?> evaluate() {
        Value<?> left = this.getLeft().evaluate();
        Value<?> right = this.getRight().evaluate();
        if (left == NullValue.NULL_INSTANCE || right == NullValue.NULL_INSTANCE) {
            throw new ExecutionException(String.format("Unable to perform less than or equal to for NULL values `%s`, '%s'", left, right));
        }
        boolean result = Objects.equals(left.getClass(), right.getClass()) && left instanceof ComparableValue ? ((Comparable)left.getValue()).compareTo(right.getValue()) <= 0 : left.toString().compareTo(right.toString()) <= 0;
        return new LogicalValue(result);
    }
}

