/*
 * Decompiled with CFR 0.152.
 */
package scrum.expression.operator;

import scrum.exception.ExecutionException;
import scrum.expression.Expression;
import scrum.expression.operator.BinaryOperatorExpression;
import scrum.expression.value.NullValue;
import scrum.expression.value.NumericValue;
import scrum.expression.value.Value;

public class FloorDivisionOperator
extends BinaryOperatorExpression {
    public FloorDivisionOperator(Expression left, Expression right) {
        super(left, right);
    }

    @Override
    public Value<?> evaluate() {
        Value<?> left = this.getLeft().evaluate();
        Value<?> right = this.getRight().evaluate();
        if (left == NullValue.NULL_INSTANCE || right == NullValue.NULL_INSTANCE) {
            throw new ExecutionException(String.format("Unable to perform floor division for NULL values `%s`, '%s'", left, right));
        }
        if (left instanceof NumericValue && right instanceof NumericValue) {
            return new NumericValue(Math.floor((Double)((NumericValue)left).getValue() / (Double)((NumericValue)right).getValue()));
        }
        throw new ExecutionException(String.format("Unable to divide non numeric values `%s` and `%s`", left, right));
    }
}

