/*
 * Decompiled with CFR 0.152.
 */
package scrum.expression.operator;

import scrum.exception.ExecutionException;
import scrum.expression.Expression;
import scrum.expression.operator.BinaryOperatorExpression;
import scrum.expression.value.NumericValue;
import scrum.expression.value.Value;

public class DivisionOperator
extends BinaryOperatorExpression {
    public DivisionOperator(Expression left, Expression right) {
        super(left, right);
    }

    @Override
    public Value<?> evaluate() {
        Value<?> left = this.getLeft().evaluate();
        Value<?> right = this.getRight().evaluate();
        if (left instanceof NumericValue && right instanceof NumericValue) {
            return new NumericValue((Double)((NumericValue)left).getValue() / (Double)((NumericValue)right).getValue());
        }
        throw new ExecutionException(String.format("Unable to divide non numeric values `%s` and `%s`", left, right));
    }
}

