/*
 * Decompiled with CFR 0.152.
 */
package scrum.expression.operator;

import scrum.exception.ExecutionException;
import scrum.expression.AssignExpression;
import scrum.expression.Expression;
import scrum.expression.FunctionExpression;
import scrum.expression.VariableExpression;
import scrum.expression.operator.BinaryOperatorExpression;
import scrum.expression.value.ClassValue;
import scrum.expression.value.ThisValue;
import scrum.expression.value.Value;

public class ClassPropertyOperator
extends BinaryOperatorExpression
implements AssignExpression {
    public ClassPropertyOperator(Expression left, Expression right) {
        super(left, right);
    }

    @Override
    public Value<?> evaluate() {
        ClassValue left = this.getLeft().evaluate();
        if (left instanceof ThisValue) {
            left = ((ThisValue)((Object)left)).getValue();
        }
        if (left instanceof ClassValue) {
            if (this.getRight() instanceof VariableExpression) {
                return left.getValue(((VariableExpression)this.getRight()).getName());
            }
            if (this.getRight() instanceof FunctionExpression) {
                return ((FunctionExpression)this.getRight()).evaluate(left);
            }
        }
        throw new ExecutionException(String.format("Unable to access class's property `%s``", this.getRight()));
    }

    @Override
    public void assign(Value<?> value) {
        ClassValue left = this.getLeft().evaluate();
        if (left instanceof ThisValue) {
            left = ((ThisValue)((Object)left)).getValue();
        }
        if (left instanceof ClassValue && this.getRight() instanceof VariableExpression) {
            String propertyName = ((VariableExpression)this.getRight()).getName();
            left.setValue(propertyName, value);
        }
    }
}

