/*
 * Decompiled with CFR 0.152.
 */
package scrum.expression.operator;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import scrum.expression.Expression;
import scrum.expression.operator.BinaryOperatorExpression;
import scrum.expression.value.ArrayValue;
import scrum.expression.value.NumericValue;
import scrum.expression.value.TextValue;
import scrum.expression.value.Value;

public class AdditionOperator
extends BinaryOperatorExpression {
    public AdditionOperator(Expression left, Expression right) {
        super(left, right);
    }

    @Override
    public Value<?> evaluate() {
        Value<?> left = this.getLeft().evaluate();
        Value<?> right = this.getRight().evaluate();
        if (left instanceof NumericValue && right instanceof NumericValue) {
            return new NumericValue((Double)((NumericValue)left).getValue() + (Double)((NumericValue)right).getValue());
        }
        if (left instanceof ArrayValue || right instanceof ArrayValue) {
            List<Value<Object>> newArray = left instanceof ArrayValue && right instanceof ArrayValue ? Stream.concat(((List)((ArrayValue)left).getValue()).stream(), ((List)((ArrayValue)right).getValue()).stream()).collect(Collectors.toList()) : (left instanceof ArrayValue ? Stream.concat(((List)((ArrayValue)left).getValue()).stream(), Stream.of(right)).collect(Collectors.toList()) : Stream.concat(((List)((ArrayValue)right).getValue()).stream(), Stream.of(left)).collect(Collectors.toList()));
            return new ArrayValue(newArray);
        }
        return new TextValue(left.toString() + right.toString());
    }
}

