/*
 * Decompiled with CFR 0.152.
 */
package scrum.expression;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import scrum.context.ClassInstanceContext;
import scrum.context.MemoryContext;
import scrum.context.MemoryScope;
import scrum.context.ReturnContext;
import scrum.context.definition.ClassDefinition;
import scrum.context.definition.DefinitionContext;
import scrum.context.definition.DefinitionScope;
import scrum.context.definition.FunctionDefinition;
import scrum.expression.Expression;
import scrum.expression.value.ClassValue;
import scrum.expression.value.NullValue;
import scrum.expression.value.Value;
import scrum.statement.FunctionStatement;

public class FunctionExpression
implements Expression {
    private final String name;
    private final List<Expression> argumentExpressions;

    @Override
    public Value<?> evaluate() {
        List<Value<?>> values = this.argumentExpressions.stream().map(Expression::evaluate).collect(Collectors.toList());
        return this.evaluate(values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value<?> evaluate(ClassValue classValue) {
        List<Value<?>> values = this.argumentExpressions.stream().map(Expression::evaluate).collect(Collectors.toList());
        ClassDefinition classDefinition = (ClassDefinition)classValue.getValue();
        DefinitionScope classDefinitionScope = classDefinition.getDefinitionScope();
        MemoryScope memoryScope = classValue.getMemoryScope();
        DefinitionContext.pushScope(classDefinitionScope);
        MemoryContext.pushScope(memoryScope);
        ClassInstanceContext.pushValue(classValue);
        try {
            Value<?> value = this.evaluate(values);
            return value;
        }
        finally {
            DefinitionContext.endScope();
            MemoryContext.endScope();
            ClassInstanceContext.popValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Value<?> evaluate(List<Value<?>> values) {
        FunctionDefinition definition = DefinitionContext.getScope().getFunction(this.name);
        FunctionStatement statement = definition.getStatement();
        MemoryContext.pushScope(MemoryContext.newScope());
        try {
            IntStream.range(0, definition.getArguments().size()).boxed().forEach(i -> MemoryContext.getScope().setLocal(definition.getArguments().get((int)i), values.size() > i ? (Value)values.get((int)i) : NullValue.NULL_INSTANCE));
            statement.execute();
            Value<?> value = ReturnContext.getScope().getResult();
            return value;
        }
        finally {
            MemoryContext.endScope();
            ReturnContext.reset();
        }
    }

    @Generated
    public FunctionExpression(String name, List<Expression> argumentExpressions) {
        this.name = name;
        this.argumentExpressions = argumentExpressions;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public List<Expression> getArgumentExpressions() {
        return this.argumentExpressions;
    }
}

