/*
 * Decompiled with CFR 0.152.
 */
package scrum.expression;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Stack;
import lombok.Generated;
import scrum.exception.SyntaxException;
import scrum.expression.ArrayExpression;
import scrum.expression.ClassExpression;
import scrum.expression.Expression;
import scrum.expression.FunctionExpression;
import scrum.expression.VariableExpression;
import scrum.expression.operator.ArrayValueOperator;
import scrum.expression.operator.BinaryOperatorExpression;
import scrum.expression.operator.Operator;
import scrum.expression.operator.OperatorExpression;
import scrum.expression.operator.UnaryOperatorExpression;
import scrum.expression.value.LogicalValue;
import scrum.expression.value.NullValue;
import scrum.expression.value.NumericValue;
import scrum.expression.value.TextValue;
import scrum.expression.value.ThisValue;
import scrum.token.Token;
import scrum.token.TokenType;
import scrum.token.TokensStack;

public class ExpressionReader {
    private final Stack<Expression> operands = new Stack();
    private final Stack<Operator> operators = new Stack();
    private final TokensStack tokens;

    private ExpressionReader(TokensStack tokens) {
        this.tokens = tokens;
    }

    public static Expression readExpression(TokensStack tokens) {
        ExpressionReader expressionReader = new ExpressionReader(tokens);
        return expressionReader.readExpression();
    }

    public static Expression readExpression(ExpressionReader expressionReader) {
        return ExpressionReader.readExpression(expressionReader.getTokens());
    }

    private boolean hasNextToken() {
        if (this.tokens.peekSameLine(TokenType.Operator, TokenType.Variable, TokenType.Numeric, TokenType.Logical, TokenType.Null, TokenType.This, TokenType.Text)) {
            return true;
        }
        return this.tokens.peekSameLine(TokenType.GroupDivider, "{", new String[0]);
    }

    private Expression readExpression() {
        block15: while (this.hasNextToken()) {
            Token token = this.tokens.next();
            switch (token.getType()) {
                case Operator: {
                    Operator operator = Operator.getType(token.getValue());
                    switch (operator) {
                        case LeftParen: {
                            this.operators.push(operator);
                            continue block15;
                        }
                        case RightParen: {
                            while (!this.operators.empty() && this.operators.peek() != Operator.LeftParen) {
                                this.applyTopOperator();
                            }
                            this.operators.pop();
                            continue block15;
                        }
                    }
                    while (!this.operators.isEmpty() && this.operators.peek().greaterThan(operator)) {
                        this.applyTopOperator();
                    }
                    this.operators.push(operator);
                    continue block15;
                }
            }
            String value = token.getValue();
            this.operands.push(switch (token.getType()) {
                case TokenType.Numeric -> new NumericValue(Double.parseDouble(value));
                case TokenType.Logical -> new LogicalValue(Boolean.valueOf(value));
                case TokenType.Text -> new TextValue(value);
                case TokenType.GroupDivider -> {
                    if (Objects.equals(token.getValue(), "{")) {
                        yield this.readArrayInstance();
                    }
                }
                case TokenType.Null -> NullValue.NULL_INSTANCE;
                case TokenType.This -> ThisValue.THIS_INSTANCE;
                default -> !this.operators.isEmpty() && this.operators.peek() == Operator.ClassInstance ? this.readClassInstance(token) : (this.tokens.peekSameLine(TokenType.GroupDivider, "USING [", new String[0]) ? this.readFunctionInvocation(token) : (this.tokens.peekSameLine(TokenType.GroupDivider, "{", new String[0]) ? this.readArrayValue(token) : new VariableExpression(value)));
            });
        }
        while (!this.operators.isEmpty()) {
            this.applyTopOperator();
        }
        if (this.operands.isEmpty()) {
            return NullValue.NULL_INSTANCE;
        }
        return this.operands.pop();
    }

    private void applyTopOperator() {
        block4: {
            Operator operator = this.operators.pop();
            Class<? extends OperatorExpression> operatorType = operator.getType();
            Expression left = this.operands.pop();
            if (BinaryOperatorExpression.class.isAssignableFrom(operatorType)) {
                Expression right = this.operands.pop();
                this.operands.push(operatorType.getConstructor(Expression.class, Expression.class).newInstance(right, left));
                break block4;
            }
            if (UnaryOperatorExpression.class.isAssignableFrom(operatorType)) {
                this.operands.push(operatorType.getConstructor(Expression.class).newInstance(left));
                break block4;
            }
            throw new SyntaxException(String.format("Operator `%s` is not supported", operatorType));
        }
    }

    private ClassExpression readClassInstance(Token token) {
        ArrayList<Expression> arguments = new ArrayList<Expression>();
        if (this.tokens.peekSameLine(TokenType.GroupDivider, "[", new String[0])) {
            this.tokens.next(TokenType.GroupDivider, "[", new String[0]);
            while (!this.tokens.peekSameLine(TokenType.GroupDivider, "]", new String[0])) {
                Expression value = ExpressionReader.readExpression(this);
                arguments.add(value);
                if (!this.tokens.peekSameLine(TokenType.GroupDivider, ",", new String[0])) continue;
                this.tokens.next();
            }
            this.tokens.next(TokenType.GroupDivider, "]", new String[0]);
        }
        return new ClassExpression(token.getValue(), arguments);
    }

    private FunctionExpression readFunctionInvocation(Token token) {
        ArrayList<Expression> arguments = new ArrayList<Expression>();
        if (this.tokens.peekSameLine(TokenType.GroupDivider, "USING [", new String[0])) {
            this.tokens.next(TokenType.GroupDivider, "USING [", new String[0]);
            while (!this.tokens.peekSameLine(TokenType.GroupDivider, "]", new String[0])) {
                Expression value = ExpressionReader.readExpression(this);
                arguments.add(value);
                if (!this.tokens.peekSameLine(TokenType.GroupDivider, ",", new String[0])) continue;
                this.tokens.next();
            }
            this.tokens.next(TokenType.GroupDivider, "]", new String[0]);
        }
        return new FunctionExpression(token.getValue(), arguments);
    }

    private ArrayExpression readArrayInstance() {
        ArrayList<Expression> values = new ArrayList<Expression>();
        while (!this.tokens.peekSameLine(TokenType.GroupDivider, "}", new String[0])) {
            Expression value = ExpressionReader.readExpression(this);
            values.add(value);
            if (!this.tokens.peekSameLine(TokenType.GroupDivider, ",", new String[0])) continue;
            this.tokens.next();
        }
        this.tokens.next(TokenType.GroupDivider, "}", new String[0]);
        return new ArrayExpression(values);
    }

    private ArrayValueOperator readArrayValue(Token token) {
        VariableExpression array = new VariableExpression(token.getValue());
        this.tokens.next(TokenType.GroupDivider, "{", new String[0]);
        Expression arrayIndex = ExpressionReader.readExpression(this);
        this.tokens.next(TokenType.GroupDivider, "}", new String[0]);
        return new ArrayValueOperator(array, arrayIndex);
    }

    @Generated
    public TokensStack getTokens() {
        return this.tokens;
    }
}

