/*
 * Decompiled with CFR 0.152.
 */
package scrum.expression;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import scrum.context.ClassInstanceContext;
import scrum.context.MemoryContext;
import scrum.context.MemoryScope;
import scrum.context.definition.ClassDefinition;
import scrum.context.definition.DefinitionContext;
import scrum.expression.Expression;
import scrum.expression.value.ClassValue;
import scrum.expression.value.NullValue;
import scrum.expression.value.Value;
import scrum.statement.ClassStatement;

public class ClassExpression
implements Expression {
    private final String name;
    private final List<Expression> argumentExpressions;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<?> evaluate() {
        List values = this.argumentExpressions.stream().map(Expression::evaluate).collect(Collectors.toList());
        ClassDefinition definition = DefinitionContext.getScope().getClass(this.name);
        ClassStatement classStatement = definition.getStatement();
        MemoryScope classScope = new MemoryScope(null);
        MemoryContext.pushScope(classScope);
        try {
            ClassValue classValue = new ClassValue(definition, classScope);
            ClassInstanceContext.pushValue(classValue);
            IntStream.range(0, definition.getArguments().size()).boxed().forEach(i -> MemoryContext.getScope().setLocal(definition.getArguments().get((int)i), values.size() > i ? (Value)values.get((int)i) : NullValue.NULL_INSTANCE));
            DefinitionContext.pushScope(definition.getDefinitionScope());
            try {
                classStatement.execute();
            }
            finally {
                DefinitionContext.endScope();
            }
            ClassValue classValue2 = classValue;
            return classValue2;
        }
        finally {
            MemoryContext.endScope();
            ClassInstanceContext.popValue();
        }
    }

    @Generated
    public ClassExpression(String name, List<Expression> argumentExpressions) {
        this.name = name;
        this.argumentExpressions = argumentExpressions;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public List<Expression> getArgumentExpressions() {
        return this.argumentExpressions;
    }
}

