/*
 * Decompiled with CFR 0.152.
 */
package scrum.context.definition;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import scrum.context.definition.ClassDefinition;
import scrum.context.definition.FunctionDefinition;
import scrum.exception.ExecutionException;

public class DefinitionScope {
    private final Set<ClassDefinition> classes = new HashSet<ClassDefinition>();
    private final Set<FunctionDefinition> functions = new HashSet<FunctionDefinition>();
    private final DefinitionScope parent;

    public DefinitionScope(DefinitionScope parent) {
        this.parent = parent;
    }

    public ClassDefinition getClass(String name) {
        Optional<ClassDefinition> classDefinition = this.classes.stream().filter(t -> t.getName().equals(name)).findAny();
        if (classDefinition.isPresent()) {
            return classDefinition.get();
        }
        if (this.parent != null) {
            return this.parent.getClass(name);
        }
        throw new ExecutionException(String.format("Class is not defined: %s", name));
    }

    public void addClass(ClassDefinition classDefinition) {
        this.classes.add(classDefinition);
    }

    public FunctionDefinition getFunction(String name) {
        Optional<FunctionDefinition> functionDefinition = this.functions.stream().filter(t -> t.getName().equals(name)).findAny();
        if (functionDefinition.isPresent()) {
            return functionDefinition.get();
        }
        if (this.parent != null) {
            return this.parent.getFunction(name);
        }
        throw new ExecutionException(String.format("Function is not defined: %s", name));
    }

    public void addFunction(FunctionDefinition functionDefinition) {
        this.functions.add(functionDefinition);
    }

    @Generated
    public DefinitionScope getParent() {
        return this.parent;
    }
}

