/*
 * Decompiled with CFR 0.152.
 */
package scrum.context;

import java.util.HashMap;
import java.util.Map;
import scrum.expression.value.NullValue;
import scrum.expression.value.Value;

public class MemoryScope {
    private final Map<String, Value<?>> variables = new HashMap();
    private final MemoryScope parent;

    public MemoryScope(MemoryScope parent) {
        this.parent = parent;
    }

    public Value<?> get(String name) {
        Value<?> value = this.variables.get(name);
        if (value != null) {
            return value;
        }
        if (this.parent != null) {
            return this.parent.get(name);
        }
        return NullValue.NULL_INSTANCE;
    }

    public Value<?> getLocal(String name) {
        return this.variables.get(name);
    }

    public void set(String name, Value<?> value) {
        MemoryScope variableScope = this.findScope(name);
        if (variableScope == null) {
            this.setLocal(name, value);
        } else {
            variableScope.setLocal(name, value);
        }
    }

    public void setLocal(String name, Value<?> value) {
        this.variables.put(name, value);
    }

    private MemoryScope findScope(String name) {
        if (this.variables.containsKey(name)) {
            return this;
        }
        return this.parent == null ? null : this.parent.findScope(name);
    }
}

