/*
 * Decompiled with CFR 0.152.
 */
package scrum;

import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import lombok.Generated;
import scrum.context.definition.ClassDefinition;
import scrum.context.definition.DefinitionContext;
import scrum.context.definition.DefinitionScope;
import scrum.context.definition.FunctionDefinition;
import scrum.exception.SyntaxException;
import scrum.expression.Expression;
import scrum.expression.ExpressionReader;
import scrum.expression.VariableExpression;
import scrum.expression.operator.OperatorExpression;
import scrum.expression.value.LogicalValue;
import scrum.statement.ClassStatement;
import scrum.statement.CompositeStatement;
import scrum.statement.ConditionStatement;
import scrum.statement.ExpressionStatement;
import scrum.statement.FunctionStatement;
import scrum.statement.InputStatement;
import scrum.statement.ReturnStatement;
import scrum.statement.SayStatement;
import scrum.statement.loop.AbstractLoopStatement;
import scrum.statement.loop.BreakStatement;
import scrum.statement.loop.ForLoopStatement;
import scrum.statement.loop.IterableLoopStatement;
import scrum.statement.loop.NextStatement;
import scrum.statement.loop.WhileLoopStatement;
import scrum.token.Token;
import scrum.token.TokenType;
import scrum.token.TokensStack;

public class StatementParser {
    private final TokensStack tokens;
    private final Scanner scanner;
    private final CompositeStatement compositeStatement;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parse(StatementParser parent, CompositeStatement compositeStatement, DefinitionScope definitionScope) {
        DefinitionContext.pushScope(definitionScope);
        try {
            StatementParser parser = new StatementParser(parent.getTokens(), parent.getScanner(), compositeStatement);
            while (parser.hasNextStatement()) {
                parser.parseExpression();
            }
        }
        finally {
            DefinitionContext.endScope();
        }
    }

    public static void parse(List<Token> tokens, CompositeStatement compositeStatement) {
        StatementParser parser = new StatementParser(new TokensStack(tokens), new Scanner(System.in), compositeStatement);
        while (parser.hasNextStatement()) {
            parser.parseExpression();
        }
    }

    private boolean hasNextStatement() {
        if (!this.tokens.hasNext()) {
            return false;
        }
        if (this.tokens.peek(TokenType.Operator, TokenType.Variable, TokenType.This)) {
            return true;
        }
        if (this.tokens.peek(TokenType.Keyword, new TokenType[0])) {
            return !this.tokens.peek(TokenType.Keyword, "ELSE", "ELSEIF", "end", "END OF STORY", "END OF EPIC", "END IF", "END OF ITERATION");
        }
        return false;
    }

    private void parseExpression() {
        Token token = this.tokens.next(TokenType.Keyword, TokenType.Variable, TokenType.This, TokenType.Operator);
        switch (token.getType()) {
            case Variable: 
            case Operator: 
            case This: {
                this.parseExpressionStatement();
                break;
            }
            case Keyword: {
                this.parseKeywordStatement(token);
                break;
            }
            default: {
                throw new SyntaxException(String.format("Statement can't start with the following lexeme `%s`", token));
            }
        }
    }

    private void parseExpressionStatement() {
        this.tokens.back();
        Expression value = ExpressionReader.readExpression(this.tokens);
        ExpressionStatement statement = new ExpressionStatement(value);
        this.compositeStatement.addStatement(statement);
    }

    private void parseKeywordStatement(Token token) {
        switch (token.getValue()) {
            case "SAY": {
                this.parsePrintStatement();
                break;
            }
            case "ASK": {
                this.parseInputStatement();
                break;
            }
            case "IF": {
                this.parseConditionStatement();
                break;
            }
            case "EPIC": {
                this.parseClassDefinition();
                break;
            }
            case "USER STORY": {
                this.parseFunctionDefinition();
                break;
            }
            case "RETURN ANSWER": {
                this.parseReturnStatement();
                break;
            }
            case "I WANT TO ITERATE": {
                this.parseLoopStatement();
                break;
            }
            case "break": {
                this.parseBreakStatement();
                break;
            }
            case "next": {
                this.parseNextStatement();
                break;
            }
            default: {
                throw new SyntaxException(String.format("Failed to parse a keyword: %s", token.getValue()));
            }
        }
    }

    private void parseExecutionStatement() {
        Token type = this.tokens.next(TokenType.Text, new TokenType[0]);
    }

    private void parsePrintStatement() {
        Expression expression = ExpressionReader.readExpression(this.tokens);
        SayStatement statement = new SayStatement(expression);
        this.compositeStatement.addStatement(statement);
    }

    private void parseInputStatement() {
        Token variable = this.tokens.next(TokenType.Variable, new TokenType[0]);
        InputStatement statement = new InputStatement(variable.getValue(), this.scanner::nextLine);
        this.compositeStatement.addStatement(statement);
    }

    private void parseConditionStatement() {
        this.tokens.back();
        ConditionStatement conditionStatement = new ConditionStatement();
        while (!this.tokens.peek(TokenType.Keyword, "END IF", new String[0])) {
            Token type = this.tokens.next(TokenType.Keyword, "IF", "ELSEIF", "ELSE");
            Expression caseCondition = type.getValue().equals("ELSE") ? new LogicalValue(true) : ExpressionReader.readExpression(this.tokens);
            CompositeStatement caseStatement = new CompositeStatement();
            DefinitionScope caseScope = DefinitionContext.newScope();
            StatementParser.parse(this, caseStatement, caseScope);
            conditionStatement.addCase(caseCondition, caseStatement);
        }
        this.tokens.next(TokenType.Keyword, "END IF", new String[0]);
        this.compositeStatement.addStatement(conditionStatement);
    }

    private void parseClassDefinition() {
        ArrayList<String> arguments = new ArrayList<String>();
        String epicName = this.tokens.next(TokenType.Text, new TokenType[0]).getValue().replace(" ", "_");
        if (this.tokens.peek(TokenType.GroupDivider, "USING [", new String[0])) {
            this.tokens.next(TokenType.GroupDivider, "USING [", new String[0]);
            while (!this.tokens.peek(TokenType.GroupDivider, "]", new String[0])) {
                Token argumentToken = this.tokens.next(TokenType.Variable, new TokenType[0]);
                arguments.add(argumentToken.getValue());
                if (!this.tokens.peek(TokenType.GroupDivider, ",", new String[0])) continue;
                this.tokens.next();
            }
            this.tokens.next(TokenType.GroupDivider, "]", new String[0]);
        }
        ClassStatement classStatement = new ClassStatement();
        DefinitionScope classScope = DefinitionContext.newScope();
        ClassDefinition classDefinition = new ClassDefinition(epicName, arguments, classStatement, classScope);
        DefinitionContext.getScope().addClass(classDefinition);
        StatementParser.parse(this, classStatement, classScope);
        this.tokens.next(TokenType.Keyword, "END OF EPIC", new String[0]);
    }

    private void parseFunctionDefinition() {
        DefinitionContext.getScope().getParent();
        Token type = this.tokens.next(TokenType.Text, new TokenType[0]);
        String userStoryName = type.getValue().replace(" ", "_");
        ArrayList<String> arguments = new ArrayList<String>();
        if (this.tokens.peek(TokenType.GroupDivider, "USING [", new String[0])) {
            this.tokens.next(TokenType.GroupDivider, "USING [", new String[0]);
            while (!this.tokens.peek(TokenType.GroupDivider, "]", new String[0])) {
                Token argumentToken = this.tokens.next(TokenType.Variable, new TokenType[0]);
                arguments.add(argumentToken.getValue());
                if (!this.tokens.peek(TokenType.GroupDivider, ",", new String[0])) continue;
                this.tokens.next();
            }
            this.tokens.next(TokenType.GroupDivider, "]", new String[0]);
        }
        FunctionStatement functionStatement = new FunctionStatement();
        DefinitionScope functionScope = DefinitionContext.newScope();
        FunctionDefinition functionDefinition = new FunctionDefinition(type.getValue(), arguments, functionStatement, functionScope);
        DefinitionContext.getScope().addFunction(functionDefinition);
        StatementParser.parse(this, functionStatement, functionScope);
        this.tokens.next(TokenType.Keyword, "END OF STORY", new String[0]);
    }

    private void parseReturnStatement() {
        Expression expression = ExpressionReader.readExpression(this.tokens);
        ReturnStatement statement = new ReturnStatement(expression);
        this.compositeStatement.addStatement(statement);
    }

    private void parseLoopStatement() {
        Expression loopExpression = ExpressionReader.readExpression(this.tokens);
        if (loopExpression instanceof OperatorExpression || loopExpression instanceof VariableExpression) {
            AbstractLoopStatement loopStatement;
            if (loopExpression instanceof VariableExpression && this.tokens.peek(TokenType.Keyword, "FOR RANGE", new String[0])) {
                VariableExpression variable = (VariableExpression)loopExpression;
                this.tokens.next(TokenType.Keyword, "FOR RANGE", new String[0]);
                Expression bounds = ExpressionReader.readExpression(this.tokens);
                if (this.tokens.peek(TokenType.GroupDivider, "TILL", new String[0])) {
                    this.tokens.next(TokenType.GroupDivider, "TILL", new String[0]);
                    Expression upperBound = ExpressionReader.readExpression(this.tokens);
                    if (this.tokens.peek(TokenType.Keyword, "by", new String[0])) {
                        this.tokens.next(TokenType.Keyword, "by", new String[0]);
                        Expression step = ExpressionReader.readExpression(this.tokens);
                        loopStatement = new ForLoopStatement(variable, bounds, upperBound, step);
                    } else {
                        loopStatement = new ForLoopStatement(variable, bounds, upperBound);
                    }
                } else {
                    loopStatement = new IterableLoopStatement(variable, bounds);
                }
            } else {
                loopStatement = new WhileLoopStatement(loopExpression);
            }
            DefinitionScope loopScope = DefinitionContext.newScope();
            StatementParser.parse(this, loopStatement, loopScope);
            this.tokens.next(TokenType.Keyword, "END OF ITERATION", new String[0]);
            this.compositeStatement.addStatement(loopStatement);
        }
    }

    private void parseBreakStatement() {
        BreakStatement statement = new BreakStatement();
        this.compositeStatement.addStatement(statement);
    }

    private void parseNextStatement() {
        NextStatement statement = new NextStatement();
        this.compositeStatement.addStatement(statement);
    }

    @Generated
    public StatementParser(TokensStack tokens, Scanner scanner, CompositeStatement compositeStatement) {
        this.tokens = tokens;
        this.scanner = scanner;
        this.compositeStatement = compositeStatement;
    }

    @Generated
    public TokensStack getTokens() {
        return this.tokens;
    }

    @Generated
    public Scanner getScanner() {
        return this.scanner;
    }

    @Generated
    public CompositeStatement getCompositeStatement() {
        return this.compositeStatement;
    }
}

