/*
 * Decompiled with CFR 0.152.
 */
package scrum;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import scrum.exception.TokenException;
import scrum.token.Token;
import scrum.token.TokenType;

public class LexicalParser {
    private final List<Token> tokens;
    private final String source;
    private final List<Integer> linesIndices;

    public LexicalParser(String source) {
        this.source = source;
        this.tokens = new ArrayList<Token>();
        this.linesIndices = IntStream.iterate(source.indexOf("\n"), index -> index >= 0, index -> source.indexOf("\n", index + 1)).boxed().collect(Collectors.toList());
    }

    public List<Token> parse() {
        for (int position = 0; position < this.source.length(); position += this.nextToken(position)) {
        }
        return this.tokens;
    }

    private int nextToken(int position) {
        String nextToken = this.source.substring(position);
        int row = IntStream.range(0, this.linesIndices.size()).filter(i -> position <= this.linesIndices.get(i)).findFirst().orElse(this.linesIndices.size()) + 1;
        for (TokenType tokenType : TokenType.values()) {
            Pattern pattern = Pattern.compile("^" + tokenType.getRegex());
            Matcher matcher = pattern.matcher(nextToken);
            if (!matcher.find()) continue;
            if (tokenType != TokenType.Whitespace) {
                String value = matcher.groupCount() > 0 ? matcher.group(1) : matcher.group();
                Token token = Token.builder().type(tokenType).value(value).row(row).build();
                this.tokens.add(token);
            }
            return matcher.group().length();
        }
        throw new TokenException(String.format("invalid expression at line %d", row));
    }
}

